/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.disabling_swipe.DisablingSwipeAoE;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class DisablingSwipeSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "disabling_swipe");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(5).setCooldownSeconds(15.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Float.valueOf(this.getEffectDuration(spellLevel, caster))}), Component.m_237110_((String)"ui.cataclysm_spellbooks.recast_bonus_damage", (Object[])new Object[]{Float.valueOf(this.getBonusDamage(spellLevel, caster))}));
    }

    public DisablingSwipeSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 3;
        this.castTime = 10;
        this.baseManaCost = 30;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return spellLevel;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        PlayerRecasts recasts = playerMagicData.getPlayerRecasts();
        if (!recasts.hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 100, castSource, null), playerMagicData);
        } else {
            RecastInstance recastInstance = recasts.getRecastInstance(this.getSpellId());
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        float radius = 3.25f;
        float distance = 1.65f;
        Vec3 hitLocation = serverPlayer.m_20182_().m_82520_(0.0, (double)(serverPlayer.m_20206_() * 0.3f), 0.0).m_82549_(serverPlayer.m_20156_().m_82542_((double)distance, (double)0.35f, (double)distance));
        List entities = serverPlayer.m_9236_().m_45933_((Entity)serverPlayer, AABB.m_165882_((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity target : entities) {
            if (!serverPlayer.m_6087_() || !(serverPlayer.m_20280_(target) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)serverPlayer.m_9236_(), (Vec3)serverPlayer.m_146892_(), (Vec3)target.m_20191_().m_82399_(), (boolean)true) || !DamageSources.applyDamage((Entity)target, (float)(this.getDamage(recastInstance.getSpellLevel(), (LivingEntity)serverPlayer) + this.getBonusDamage(recastInstance.getSpellLevel(), (LivingEntity)serverPlayer)), (DamageSource)this.getDamageSource((Entity)serverPlayer))) continue;
            MagicManager.spawnParticles((Level)serverPlayer.m_9236_(), (ParticleOptions)ParticleHelper.ELECTRIC_SPARKS, (double)target.m_20185_(), (double)(target.m_20186_() + (double)(target.m_20206_() * 0.5f)), (double)target.m_20189_(), (int)50, (double)(target.m_20205_() * 0.5f), (double)(target.m_20206_() * 0.5f), (double)(target.m_20205_() * 0.5f), (double)0.03, (boolean)false);
            EnchantmentHelper.m_44896_((LivingEntity)serverPlayer, (Entity)target);
        }
        boolean mirrored = false;
        SpellSelectionManager.SelectionOption selection = new SpellSelectionManager((Player)serverPlayer).getSelection();
        new SpellSelectionManager((Player)serverPlayer).getSelection();
        if (selection != null) {
            mirrored = selection.slot.equals(SpellSelectionManager.OFFHAND);
        }
        DisablingSwipeAoE swipe = new DisablingSwipeAoE(serverPlayer.m_9236_(), mirrored);
        swipe.m_20219_(hitLocation);
        swipe.m_146922_(serverPlayer.m_146908_());
        swipe.setEffectDuration(this.getEffectDuration(recastInstance.getSpellLevel(), (LivingEntity)serverPlayer));
        swipe.setEffectAmplifier(recastInstance.getSpellLevel());
        serverPlayer.m_9236_().m_7967_((Entity)swipe);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) / 3.5f + Utils.getWeaponDamage((LivingEntity)entity, (MobType)MobType.f_21640_);
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        return this.getRecastCount(spellLevel, caster);
    }

    private float getEffectDuration(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster, (MobType)MobType.f_21640_);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }
}

