/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.common.entities;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.base.ext.BlockPosExtKt;
import site.siredvin.broccolium.modules.storage.item.AgnosticItemStorageLookup;
import site.siredvin.broccolium.modules.storage.item.ItemStorageUtils;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemSink;
import site.siredvin.turtlematic.common.setup.EntityTypes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0014J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010$\u001a\u00020\rH\u0016R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lsite/siredvin/turtlematic/common/entities/ShootedItemProjectile;", "Lnet/minecraft/world/entity/projectile/ThrowableProjectile;", "Lnet/minecraft/world/entity/projectile/ItemSupplier;", "level", "Lnet/minecraft/world/level/Level;", "x", "", "y", "z", "<init>", "(Lnet/minecraft/world/level/Level;DDD)V", "(Lnet/minecraft/world/level/Level;)V", "value", "Lnet/minecraft/world/item/ItemStack;", "stack", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "setStack", "(Lnet/minecraft/world/item/ItemStack;)V", "decayTicker", "", "startDecaying", "", "onHitBlock", "", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "onHitEntity", "Lnet/minecraft/world/phys/EntityHitResult;", "tick", "defineSynchedData", "isNoGravity", "addAdditionalSaveData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "getItem", "Companion", "turtlematic-forge-1.20.1"})
public final class ShootedItemProjectile
extends ThrowableProjectile
implements ItemSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int decayTicker;
    private boolean startDecaying;
    @NotNull
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK;
    private static final int DEFAULT_DECAY_TICKS = 10;

    public ShootedItemProjectile(@NotNull Level level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(EntityTypes.INSTANCE.getSHOOTED_ITEM_TYPE().get(), x, y, z, level);
        this.decayTicker = 10;
    }

    public ShootedItemProjectile(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this(level, 0.0, 0.0, 0.0);
    }

    @NotNull
    public final ItemStack getStack() {
        Object object = this.m_20088_().m_135370_(DATA_ITEM_STACK);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.item.ItemStack");
        return (ItemStack)object;
    }

    public final void setStack(@NotNull ItemStack value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)value.m_41777_());
    }

    protected void m_8060_(@NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!this.m_9236_().f_46443_) {
            Level level = this.m_9236_();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            BlockPos blockPos = hit.m_82425_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            AgnosticItemSink targetableStorage = AgnosticItemStorageLookup.INSTANCE.extractItemSink(level, blockPos, this.m_9236_().m_7702_(hit.m_82425_()));
            if (targetableStorage != null) {
                this.m_6074_();
                ItemStack itemStack = this.getStack();
                BlockPos blockPos2 = hit.m_82425_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                Level level2 = this.m_9236_();
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
                ItemStorageUtils.INSTANCE.toInventoryOrToWorld(itemStack, targetableStorage, blockPos2, level2);
                return;
            }
        }
        super.m_8060_(hit);
        if (!(this.m_20184_().m_82553_() == 0.0)) {
            this.m_20256_(Vec3.f_82478_);
            this.startDecaying = true;
        }
    }

    protected void m_5790_(@NotNull EntityHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!this.m_9236_().f_46443_) {
            Level level = this.m_9236_();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            Entity entity = hit.m_82443_();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
            AgnosticItemSink targetableStorage = AgnosticItemStorageLookup.INSTANCE.extractItemSink(level, entity);
            if (targetableStorage != null) {
                this.m_6074_();
                ItemStack itemStack = this.getStack();
                Vec3 vec3 = hit.m_82450_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLocation(...)");
                BlockPos blockPos = BlockPosExtKt.toBlockPos((Vec3)vec3);
                Level level2 = this.m_9236_();
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
                ItemStorageUtils.INSTANCE.toInventoryOrToWorld(itemStack, targetableStorage, blockPos, level2);
                return;
            }
        }
        super.m_5790_(hit);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20184_().m_82553_() == 0.0 && this.startDecaying) {
            int n = this.decayTicker;
            this.decayTicker = n + -1;
            if (this.decayTicker <= 0) {
                Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)(this.m_20186_() + 0.5), (double)this.m_20189_(), (ItemStack)this.getStack());
                this.m_6074_();
            }
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public boolean m_20068_() {
        return super.m_20068_() || this.m_20184_().m_82553_() == 0.0;
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7380_(tag);
        ItemStack stack = this.getStack();
        if (!stack.m_41619_()) {
            tag.m_128365_("Item", (Tag)stack.m_41739_(new CompoundTag()));
        }
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7378_(tag);
        this.setStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")));
    }

    @NotNull
    public ItemStack m_7846_() {
        return this.getStack();
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(ShootedItemProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_ITEM_STACK = entityDataAccessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsite/siredvin/turtlematic/common/entities/ShootedItemProjectile$Companion;", "", "<init>", "()V", "DATA_ITEM_STACK", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/world/item/ItemStack;", "DEFAULT_DECAY_TICKS", "", "turtlematic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

