/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironmentComponent;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.casting.mishaps.MishapDisallowedSpell;
import at.petrak.hexcasting.api.casting.mishaps.MishapEntityTooFarAway;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.HexUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CastingEnvironment {
    private static final List<BiConsumer<CastingEnvironment, CompoundTag>> createEventListeners = new ArrayList<BiConsumer<CastingEnvironment, CompoundTag>>();
    private boolean createEventTriggered = false;
    protected final ServerLevel world;
    protected Map<CastingEnvironmentComponent.Key<?>, @NotNull CastingEnvironmentComponent> componentMap = new HashMap();
    private final List<CastingEnvironmentComponent.PostExecution> postExecutions = new ArrayList<CastingEnvironmentComponent.PostExecution>();
    private final List<CastingEnvironmentComponent.PostCast> postCasts = new ArrayList<CastingEnvironmentComponent.PostCast>();
    private final List<CastingEnvironmentComponent.ExtractMedia.Pre> preMediaExtract = new ArrayList<CastingEnvironmentComponent.ExtractMedia.Pre>();
    private final List<CastingEnvironmentComponent.ExtractMedia.Post> postMediaExtract = new ArrayList<CastingEnvironmentComponent.ExtractMedia.Post>();
    private final List<CastingEnvironmentComponent.IsVecInRange> isVecInRanges = new ArrayList<CastingEnvironmentComponent.IsVecInRange>();
    private final List<CastingEnvironmentComponent.HasEditPermissionsAt> hasEditPermissionsAts = new ArrayList<CastingEnvironmentComponent.HasEditPermissionsAt>();

    public static void addCreateEventListener(BiConsumer<CastingEnvironment, CompoundTag> listener) {
        createEventListeners.add(listener);
    }

    @Deprecated(since="0.11.0-pre-660")
    public static void addCreateEventListener(Consumer<CastingEnvironment> listener) {
        createEventListeners.add((env, data) -> listener.accept((CastingEnvironment)env));
    }

    public final void triggerCreateEvent(CompoundTag userData) {
        if (!this.createEventTriggered) {
            for (BiConsumer<CastingEnvironment, CompoundTag> listener : createEventListeners) {
                listener.accept(this, userData);
            }
            this.createEventTriggered = true;
        }
    }

    protected CastingEnvironment(ServerLevel world) {
        this.world = world;
    }

    public final ServerLevel getWorld() {
        return this.world;
    }

    public int maxOpCount() {
        return HexConfig.server().maxOpCount();
    }

    @Deprecated(since="0.11.1-7-pre-619")
    @Nullable
    public ServerPlayer getCaster() {
        ServerPlayer sp;
        LivingEntity livingEntity = this.getCastingEntity();
        return livingEntity instanceof ServerPlayer ? (sp = (ServerPlayer)livingEntity) : null;
    }

    @Nullable
    public abstract LivingEntity getCastingEntity();

    public abstract MishapEnvironment getMishapEnvironment();

    public <T extends CastingEnvironmentComponent> void addExtension(@NotNull T extension) {
        this.componentMap.put(extension.getKey(), extension);
        if (extension instanceof CastingEnvironmentComponent.PostExecution) {
            CastingEnvironmentComponent.PostExecution postExecution = (CastingEnvironmentComponent.PostExecution)extension;
            this.postExecutions.add(postExecution);
        }
        if (extension instanceof CastingEnvironmentComponent.PostCast) {
            CastingEnvironmentComponent.PostCast postCast = (CastingEnvironmentComponent.PostCast)extension;
            this.postCasts.add(postCast);
        }
        if (extension instanceof CastingEnvironmentComponent.ExtractMedia) {
            CastingEnvironmentComponent.ExtractMedia extractMedia = (CastingEnvironmentComponent.ExtractMedia)extension;
            if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Pre) {
                CastingEnvironmentComponent.ExtractMedia.Pre pre = (CastingEnvironmentComponent.ExtractMedia.Pre)extension;
                this.preMediaExtract.add(pre);
            } else if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Post) {
                CastingEnvironmentComponent.ExtractMedia.Post post = (CastingEnvironmentComponent.ExtractMedia.Post)extension;
                this.postMediaExtract.add(post);
            }
        }
        if (extension instanceof CastingEnvironmentComponent.IsVecInRange) {
            CastingEnvironmentComponent.IsVecInRange isVecInRange = (CastingEnvironmentComponent.IsVecInRange)extension;
            this.isVecInRanges.add(isVecInRange);
        }
        if (extension instanceof CastingEnvironmentComponent.HasEditPermissionsAt) {
            CastingEnvironmentComponent.HasEditPermissionsAt hasEditPermissionsAt = (CastingEnvironmentComponent.HasEditPermissionsAt)extension;
            this.hasEditPermissionsAts.add(hasEditPermissionsAt);
        }
    }

    public void removeExtension(@NotNull CastingEnvironmentComponent.Key<?> key) {
        CastingEnvironmentComponent extension = this.componentMap.remove(key);
        if (extension == null) {
            return;
        }
        if (extension instanceof CastingEnvironmentComponent.PostExecution) {
            CastingEnvironmentComponent.PostExecution postExecution = (CastingEnvironmentComponent.PostExecution)extension;
            this.postExecutions.remove(postExecution);
        }
        if (extension instanceof CastingEnvironmentComponent.PostCast) {
            CastingEnvironmentComponent.PostCast postCast = (CastingEnvironmentComponent.PostCast)extension;
            this.postCasts.remove(postCast);
        }
        if (extension instanceof CastingEnvironmentComponent.ExtractMedia) {
            CastingEnvironmentComponent.ExtractMedia extractMedia = (CastingEnvironmentComponent.ExtractMedia)extension;
            if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Pre) {
                CastingEnvironmentComponent.ExtractMedia.Pre pre = (CastingEnvironmentComponent.ExtractMedia.Pre)extension;
                this.preMediaExtract.remove(pre);
            } else if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Post) {
                CastingEnvironmentComponent.ExtractMedia.Post post = (CastingEnvironmentComponent.ExtractMedia.Post)extension;
                this.postMediaExtract.remove(post);
            }
        }
        if (extension instanceof CastingEnvironmentComponent.IsVecInRange) {
            CastingEnvironmentComponent.IsVecInRange isVecInRange = (CastingEnvironmentComponent.IsVecInRange)extension;
            this.isVecInRanges.remove(isVecInRange);
        }
        if (extension instanceof CastingEnvironmentComponent.HasEditPermissionsAt) {
            CastingEnvironmentComponent.HasEditPermissionsAt hasEditPermissionsAt = (CastingEnvironmentComponent.HasEditPermissionsAt)extension;
            this.hasEditPermissionsAts.remove(hasEditPermissionsAt);
        }
    }

    @Nullable
    public <T extends CastingEnvironmentComponent> T getExtension(@NotNull CastingEnvironmentComponent.Key<T> key) {
        return (T)this.componentMap.get(key);
    }

    public void precheckAction(PatternShapeMatch match) throws Mishap {
        ResourceLocation key = this.actionKey(match);
        if (!HexConfig.server().isActionAllowed(key)) {
            throw new MishapDisallowedSpell();
        }
    }

    @Nullable
    protected ResourceLocation actionKey(PatternShapeMatch match) {
        ResourceLocation key;
        if (match instanceof PatternShapeMatch.Normal) {
            PatternShapeMatch.Normal normal = (PatternShapeMatch.Normal)match;
            key = normal.key.m_135782_();
        } else if (match instanceof PatternShapeMatch.PerWorld) {
            PatternShapeMatch.PerWorld perWorld = (PatternShapeMatch.PerWorld)match;
            key = perWorld.key.m_135782_();
        } else if (match instanceof PatternShapeMatch.Special) {
            PatternShapeMatch.Special special = (PatternShapeMatch.Special)match;
            key = special.key.m_135782_();
        } else {
            key = null;
        }
        return key;
    }

    public void postExecution(CastResult result) {
        for (CastingEnvironmentComponent.PostExecution postExecutionComponent : this.postExecutions) {
            postExecutionComponent.onPostExecution(result);
        }
    }

    public void postCast(CastingImage image) {
        for (CastingEnvironmentComponent.PostCast postCastComponent : this.postCasts) {
            postCastComponent.onPostCast(image);
        }
    }

    public abstract Vec3 mishapSprayPos();

    public boolean isEnlightened() {
        Advancement adv = this.world.m_7654_().m_129889_().m_136041_(HexAPI.modLoc("enlightenment"));
        if (adv == null) {
            return false;
        }
        LivingEntity caster = this.getCastingEntity();
        if (caster instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)caster;
            return player.m_8960_().m_135996_(adv).m_8193_();
        }
        return false;
    }

    public long extractMedia(long cost, boolean simulate) {
        for (CastingEnvironmentComponent.ExtractMedia.Pre pre : this.preMediaExtract) {
            cost = pre.onExtractMedia(cost, simulate);
        }
        cost = this.extractMediaEnvironment(cost, simulate);
        for (CastingEnvironmentComponent.ExtractMedia.Post post : this.postMediaExtract) {
            cost = post.onExtractMedia(cost, simulate);
        }
        return cost;
    }

    protected abstract long extractMediaEnvironment(long var1, boolean var3);

    public boolean isVecInRange(Vec3 vec) {
        boolean isInRange = this.isVecInRangeEnvironment(vec);
        for (CastingEnvironmentComponent.IsVecInRange isVecInRangeComponent : this.isVecInRanges) {
            isInRange = isVecInRangeComponent.onIsVecInRange(vec, isInRange);
        }
        return isInRange;
    }

    protected abstract boolean isVecInRangeEnvironment(Vec3 var1);

    public boolean hasEditPermissionsAt(BlockPos pos) {
        boolean hasEditPermissionsAt = this.hasEditPermissionsAtEnvironment(pos);
        for (CastingEnvironmentComponent.HasEditPermissionsAt hasEditPermissionsAtComponent : this.hasEditPermissionsAts) {
            hasEditPermissionsAt = hasEditPermissionsAtComponent.onHasEditPermissionsAt(pos, hasEditPermissionsAt);
        }
        return hasEditPermissionsAt;
    }

    protected abstract boolean hasEditPermissionsAtEnvironment(BlockPos var1);

    public final boolean isVecInWorld(Vec3 vec) {
        return this.world.m_46739_(BlockPos.m_274446_((Position)vec)) && this.world.m_6857_().m_187562_(vec.f_82479_, vec.f_82481_, 0.5);
    }

    public final boolean isVecInAmbit(Vec3 vec) {
        return this.isVecInRange(vec) && this.isVecInWorld(vec);
    }

    public final boolean isEntityInRange(Entity e) {
        return this.isEntityInRange(e, false);
    }

    public final boolean isEntityInRange(Entity e, boolean ignoreTruenameAmbit) {
        boolean truenameCheat = !ignoreTruenameAmbit && e instanceof Player && HexConfig.server().trueNameHasAmbit();
        return truenameCheat || this.isVecInWorld(e.m_20182_()) && this.isVecInRange(e.m_20182_());
    }

    public final void assertVecInRange(Vec3 vec) throws MishapBadLocation {
        this.assertVecInWorld(vec);
        if (!this.isVecInRange(vec)) {
            throw new MishapBadLocation(vec, "too_far");
        }
    }

    public final void assertPosInRange(BlockPos vec) throws MishapBadLocation {
        this.assertVecInRange(new Vec3((double)vec.m_123341_(), (double)vec.m_123342_(), (double)vec.m_123343_()));
    }

    public final void assertPosInRangeForEditing(BlockPos vec) throws MishapBadLocation {
        this.assertVecInRange(new Vec3((double)vec.m_123341_(), (double)vec.m_123342_(), (double)vec.m_123343_()));
        if (!this.canEditBlockAt(vec)) {
            throw new MishapBadLocation(Vec3.m_82512_((Vec3i)vec), "forbidden");
        }
    }

    public final boolean canEditBlockAt(BlockPos vec) {
        return this.isVecInRange(Vec3.m_82512_((Vec3i)vec)) && this.hasEditPermissionsAt(vec);
    }

    public final void assertEntityInRange(Entity e) throws MishapEntityTooFarAway {
        if (e instanceof ServerPlayer && HexConfig.server().trueNameHasAmbit()) {
            return;
        }
        if (!this.isVecInWorld(e.m_20182_())) {
            throw new MishapEntityTooFarAway(e);
        }
        if (!this.isVecInRange(e.m_20182_())) {
            throw new MishapEntityTooFarAway(e);
        }
    }

    public final void assertVecInWorld(Vec3 vec) throws MishapBadLocation {
        if (!this.isVecInWorld(vec)) {
            throw new MishapBadLocation(vec, "out_of_world");
        }
    }

    public abstract InteractionHand getCastingHand();

    public InteractionHand getOtherHand() {
        return HexUtils.otherHand(this.getCastingHand());
    }

    protected abstract List<ItemStack> getUsableStacks(StackDiscoveryMode var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<ItemStack> getUsableStacksForPlayer(StackDiscoveryMode mode, @Nullable InteractionHand castingHand, ServerPlayer caster) {
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case QUERY: {
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                if (castingHand == null) {
                    ItemStack offhand;
                    ItemStack mainhand = caster.m_21120_(InteractionHand.MAIN_HAND);
                    if (!mainhand.m_41619_()) {
                        out.add(mainhand);
                    }
                    if (!(offhand = caster.m_21120_(InteractionHand.OFF_HAND)).m_41619_()) {
                        out.add(offhand);
                    }
                } else {
                    ItemStack offhand = caster.m_21120_(HexUtils.otherHand(castingHand));
                    if (!offhand.m_41619_()) {
                        out.add(offhand);
                    }
                }
                int anchorSlot = castingHand != InteractionHand.OFF_HAND ? (caster.m_150109_().f_35977_ + 1) % 9 : 0;
                for (int delta = 0; delta < 9; ++delta) {
                    int slot = (anchorSlot + delta) % 9;
                    out.add(caster.m_150109_().m_8020_(slot));
                }
                ArrayList<ItemStack> arrayList = out;
                return arrayList;
            }
            case EXTRACTION: {
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                Inventory inv = caster.m_150109_();
                for (int i = inv.f_35974_.size() - 1; i >= 0; --i) {
                    if (i == inv.f_35977_) continue;
                    out.add((ItemStack)inv.f_35974_.get(i));
                }
                out.addAll((Collection<ItemStack>)inv.f_35976_);
                out.add(inv.m_36056_());
                ArrayList<ItemStack> arrayList = out;
                return arrayList;
            }
        }
    }

    protected abstract List<HeldItemInfo> getPrimaryStacks();

    protected List<HeldItemInfo> getPrimaryStacksForPlayer(InteractionHand castingHand, ServerPlayer caster) {
        ItemStack secondaryItem;
        ItemStack primaryItem = caster.m_21120_(castingHand);
        if (primaryItem.m_41619_()) {
            primaryItem = ItemStack.f_41583_.m_41777_();
        }
        if ((secondaryItem = caster.m_21120_(HexUtils.otherHand(castingHand))).m_41619_()) {
            secondaryItem = ItemStack.f_41583_.m_41777_();
        }
        return List.of(new HeldItemInfo(secondaryItem, HexUtils.otherHand(castingHand)), new HeldItemInfo(primaryItem, castingHand));
    }

    @Nullable
    public ItemStack queryForMatchingStack(Predicate<ItemStack> stackOk) {
        List<ItemStack> stacks = this.getUsableStacks(StackDiscoveryMode.QUERY);
        for (ItemStack stack : stacks) {
            if (!stackOk.test(stack)) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public HeldItemInfo getHeldItemToOperateOn(Predicate<ItemStack> stackOk) {
        List<HeldItemInfo> stacks = this.getPrimaryStacks();
        for (HeldItemInfo stack : stacks) {
            if (!stackOk.test(stack.stack)) continue;
            return stack;
        }
        return null;
    }

    protected boolean isCreativeMode() {
        return false;
    }

    public boolean withdrawItem(Predicate<ItemStack> stackOk, int count, boolean actuallyRemove) {
        if (this.isCreativeMode()) {
            return true;
        }
        List<ItemStack> stacks = this.getUsableStacks(StackDiscoveryMode.EXTRACTION);
        int presentCount = 0;
        ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (!stackOk.test(stack)) continue;
            matches.add(stack);
            if ((presentCount += stack.m_41613_()) < count) continue;
            break;
        }
        if (presentCount < count) {
            return false;
        }
        if (!actuallyRemove) {
            return true;
        }
        int remaining = count;
        for (ItemStack match : matches) {
            int toWithdraw = Math.min(match.m_41613_(), remaining);
            match.m_41774_(toWithdraw);
            if ((remaining -= toWithdraw) > 0) continue;
            return true;
        }
        throw new IllegalStateException("unreachable");
    }

    public abstract boolean replaceItem(Predicate<ItemStack> var1, ItemStack var2, @Nullable InteractionHand var3);

    public boolean replaceItemForPlayer(Predicate<ItemStack> stackOk, ItemStack replaceWith, @Nullable InteractionHand hand, ServerPlayer caster) {
        if (caster == null) {
            return false;
        }
        if (hand != null && stackOk.test(caster.m_21120_(hand))) {
            caster.m_21008_(hand, replaceWith);
            return true;
        }
        Inventory inv = caster.m_150109_();
        for (int i = inv.f_35974_.size() - 1; i >= 0; --i) {
            if (i == inv.f_35977_ || !stackOk.test((ItemStack)inv.f_35974_.get(i))) continue;
            inv.m_6836_(i, replaceWith);
            return true;
        }
        if (stackOk.test(caster.m_21120_(this.getOtherHand()))) {
            caster.m_21008_(this.getOtherHand(), replaceWith);
            return true;
        }
        if (stackOk.test(caster.m_21120_(this.getCastingHand()))) {
            caster.m_21008_(this.getCastingHand(), replaceWith);
            return true;
        }
        return false;
    }

    public abstract FrozenPigment getPigment();

    @Nullable
    public abstract FrozenPigment setPigment(@Nullable FrozenPigment var1);

    public abstract void produceParticles(ParticleSpray var1, FrozenPigment var2);

    public abstract void printMessage(Component var1);

    protected static enum StackDiscoveryMode {
        QUERY,
        EXTRACTION;

    }

    public record HeldItemInfo(ItemStack stack, @Nullable InteractionHand hand) {
        public ItemStack component1() {
            return this.stack;
        }

        @Nullable
        public InteractionHand component2() {
            return this.hand;
        }
    }
}

