/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.client.render.RenderLib;

public record PatternColors(int innerStartColor, int innerEndColor, int outerStartColor, int outerEndColor, int startingDotColor, int gridDotsColor) {
    public static final PatternColors DEFAULT_PATTERN_COLOR = new PatternColors(-11186860, -2963256);
    public static final PatternColors DIMMED_COLOR = new PatternColors(-4937046, -2963256);
    public static final PatternColors DEFAULT_GRADIENT_COLOR = DEFAULT_PATTERN_COLOR.withGradientEnds(DIMMED_COLOR);
    public static final int STARTING_DOT = -10781737;
    public static final int GRID_DOTS = -2133669688;
    public static final PatternColors READABLE_SCROLL_COLORS = DEFAULT_PATTERN_COLOR.withDots(true, false);
    public static final PatternColors READABLE_GRID_SCROLL_COLORS = DEFAULT_PATTERN_COLOR.withDots(true, true);
    public static final PatternColors SLATE_WOBBLY_COLOR = PatternColors.glowyStroke(-10172161);
    public static final PatternColors SLATE_WOBBLY_PURPLE_COLOR = PatternColors.glowyStroke(-3170061);

    public PatternColors(int innerColor, int outerColor) {
        this(innerColor, innerColor, outerColor, outerColor, 0, 0);
    }

    public static PatternColors singleStroke(int color) {
        return new PatternColors(0, color);
    }

    public static PatternColors glowyStroke(int color) {
        return new PatternColors(RenderLib.screenCol(color), color);
    }

    public static PatternColors gradientStrokes(int innerStartColor, int innerEndColor, int outerStartColor, int outerEndColor) {
        return new PatternColors(innerStartColor, innerEndColor, outerStartColor, outerEndColor, 0, 0);
    }

    public static PatternColors gradientStroke(int startColor, int endColor) {
        return PatternColors.gradientStrokes(0, 0, startColor, endColor);
    }

    public PatternColors withGradientEnds(int endColorInner, int endColorOuter) {
        return new PatternColors(this.innerStartColor, endColorInner, this.outerStartColor, endColorOuter, this.startingDotColor, this.gridDotsColor);
    }

    public PatternColors withGradientEnds(PatternColors end) {
        return this.withGradientEnds(end.innerEndColor, end.outerEndColor);
    }

    public PatternColors withDotColors(int startingDotColor, int gridDotsColor) {
        return new PatternColors(this.innerStartColor, this.innerEndColor, this.outerStartColor, this.outerEndColor, startingDotColor, gridDotsColor);
    }

    public PatternColors withDots(boolean startingDot, boolean gridDots) {
        return this.withDotColors(startingDot ? -10781737 : 0, gridDots ? -2133669688 : 0);
    }
}

