/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorAppend;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorIndex;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorIndexOf;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorRemove;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorReplace;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorSlice;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorUnCons;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorUnappend;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.Collection;
import java.util.List;
import java.util.function.BinaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00040\u000fH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lat/petrak/hexcasting/common/casting/arithmetic/ListArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "()V", "OPS", "", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "kotlin.jvm.PlatformType", "arithName", "", "getOperator", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "pattern", "make2", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "op", "Ljava/util/function/BinaryOperator;", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "opTypes", "", "hexcasting-forge-1.20.1"})
public final class ListArithmetic
implements Arithmetic {
    @NotNull
    public static final ListArithmetic INSTANCE = new ListArithmetic();
    @NotNull
    private static final List<HexPattern> OPS;

    private ListArithmetic() {
    }

    @Override
    @NotNull
    public String arithName() {
        return "list_ops";
    }

    @Override
    @NotNull
    public Iterable<HexPattern> opTypes() {
        return OPS;
    }

    @Override
    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.INDEX)) {
            operator = OperatorIndex.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.SLICE)) {
            operator = OperatorSlice.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.APPEND)) {
            operator = OperatorAppend.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.UNAPPEND)) {
            operator = OperatorUnappend.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ADD)) {
            operator = this.make2(ListArithmetic::getOperator$lambda$0);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ABS)) {
            operator = new OperatorUnary(IotaMultiPredicate.all(IotaPredicate.ofType(HexIotaTypes.LIST)), ListArithmetic::getOperator$lambda$1);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.REV)) {
            operator = new OperatorUnary(IotaMultiPredicate.all(IotaPredicate.ofType(HexIotaTypes.LIST)), ListArithmetic::getOperator$lambda$2);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.INDEX_OF)) {
            operator = OperatorIndexOf.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.REMOVE)) {
            operator = OperatorRemove.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.REPLACE)) {
            operator = OperatorReplace.INSTANCE;
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.CONS)) {
            operator = new OperatorBinary(IotaMultiPredicate.pair(IotaPredicate.ofType(HexIotaTypes.LIST), IotaPredicate.TRUE), ListArithmetic::getOperator$lambda$3);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.UNCONS)) {
            operator = OperatorUnCons.INSTANCE;
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    private final OperatorBinary make2(BinaryOperator<List<Iota>> op) {
        return new OperatorBinary(IotaMultiPredicate.all(IotaPredicate.ofType(HexIotaTypes.LIST)), (arg_0, arg_1) -> ListArithmetic.make2$lambda$4(op, arg_0, arg_1));
    }

    private static final List getOperator$lambda$0(List list0, List list1) {
        Intrinsics.checkNotNullParameter((Object)list0, (String)"list0");
        Intrinsics.checkNotNullParameter((Object)list1, (String)"list1");
        return CollectionsKt.plus((Collection)list0, (Iterable)list1);
    }

    private static final Iota getOperator$lambda$1(Iota iota) {
        Intrinsics.checkNotNullParameter((Object)iota, (String)"iota");
        IotaType<ListIota> iotaType = HexIotaTypes.LIST;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"LIST");
        return new DoubleIota(Operator.Companion.downcast(iota, iotaType).getList().size());
    }

    private static final Iota getOperator$lambda$2(Iota iota) {
        Intrinsics.checkNotNullParameter((Object)iota, (String)"iota");
        IotaType<ListIota> iotaType = HexIotaTypes.LIST;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"LIST");
        SpellList spellList = Operator.Companion.downcast(iota, iotaType).getList();
        Intrinsics.checkNotNullExpressionValue((Object)spellList, (String)"downcast(iota, LIST).list");
        return new ListIota(CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)spellList)));
    }

    private static final Iota getOperator$lambda$3(Iota list, Iota iota) {
        Intrinsics.checkNotNullExpressionValue((Object)iota, (String)"iota");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        IotaType<ListIota> iotaType = HexIotaTypes.LIST;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"LIST");
        SpellList spellList = Operator.Companion.downcast(list, iotaType).getList();
        Intrinsics.checkNotNullExpressionValue((Object)spellList, (String)"downcast(list, LIST).list");
        return new ListIota(new SpellList.LPair(iota, spellList));
    }

    private static final Iota make2$lambda$4(BinaryOperator $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        IotaType<ListIota> iotaType = HexIotaTypes.LIST;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"LIST");
        SpellList spellList = Operator.Companion.downcast(i, iotaType).getList();
        Intrinsics.checkNotNullExpressionValue((Object)spellList, (String)"downcast(i, LIST).list");
        List list = CollectionsKt.toList((Iterable)spellList);
        IotaType<ListIota> iotaType2 = HexIotaTypes.LIST;
        Intrinsics.checkNotNullExpressionValue(iotaType2, (String)"LIST");
        SpellList spellList2 = Operator.Companion.downcast(j, iotaType2).getList();
        Intrinsics.checkNotNullExpressionValue((Object)spellList2, (String)"downcast(j, LIST).list");
        return new ListIota((List)$op.apply(list, CollectionsKt.toList((Iterable)spellList2)));
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.INDEX, Arithmetic.SLICE, Arithmetic.APPEND, Arithmetic.UNAPPEND, Arithmetic.ADD, Arithmetic.ABS, Arithmetic.REV, Arithmetic.INDEX_OF, Arithmetic.REMOVE, Arithmetic.REPLACE, Arithmetic.CONS, Arithmetic.UNCONS};
        OPS = CollectionsKt.listOf((Object[])objectArray);
    }
}

